<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $guarded = array('pin_code', 'blood_type_id');
    protected $fillable = array('name', 'phone', 'email', 'd_o_b', 'password');
    protected $hidden = array('access_token');

    public function bloodtype()
    {
        return $this->belongsTo('App\Models\Blood_Type');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Models\Post');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

    public function bloodtypes()
    {
        return $this->belongsToMany('App\Models\Blood_Type');
    }

    public function governorates()
    {
        return $this->belongsToMany('App\Models\Governorate');
    }

    public function donationsrequests()
    {
        return $this->hasMany('App\Models\Donation-Request');
    }

}